<?php

function install_plugins() {
	global $pagenow;
	if ( function_exists( 'get_option' ) && function_exists( 'update_option' ) ) {
		$active_plugins = (array) get_option( 'active_plugins', array() );
		$active_plugins[] = 'jetpack/jetpack.php';
		$active_plugins[] = 'mojo-marketplace-wp-plugin/mojo-marketplace.php';
		update_option( 'active_plugins', array_unique( $active_plugins ) );
		update_option( 'jetpack_activated',   3 );
		update_option( 'jetpack_do_activate', 1 );
		update_option( 'close_comments_for_old_posts', 1 );
		update_option( 'close_comments_days_old', 28 );
		update_option( 'comments_per_page', 20 );
		update_option( 'permalink_structure', '/%postname%/' );
	}
	if ( stripos( @exec( 'hostname' ), 'bluehost' ) ) {
		$source = 'https://raw.githubusercontent.com/bluehost/endurance-php-edge/production/endurance-php-edge.php';
		$destination = WP_CONTENT_DIR . '/mu-plugins/endurance-php-edge.php';
		$request = wp_remote_get( $source );
		if ( ! is_wp_error( $request ) ) {
			file_put_contents( $destination, $request['body'] );
		}
	}
	if ( function_exists( 'save_mod_rewrite_rules' ) ) {
		save_mod_rewrite_rules();
	}
	unlink( __FILE__ );
}
add_action( 'shutdown', 'install_plugins' );
